<?php
session_start();
require_once "../config/db.php";
require_once "includes/header.php";
require_once "includes/navbar.php";

/* ============================================================
   1) جلب الطلاب
   ============================================================ */
$students = $conn->query("
    SELECT 
        s.id,
        s.full_name,
        s.phone,
        s.college_name,
        s.study_type
    FROM students s
    ORDER BY s.full_name ASC
")->fetchAll(PDO::FETCH_ASSOC);

/* ============================================================
   2) جلب الدفعات + الموظف الذي أضافها
   ============================================================ */
$all_payments = $conn->query("
    SELECT 
        p.*,
        fu.name AS staff_name
    FROM payments p
    LEFT JOIN finance_users fu ON fu.id = p.finance_user_id
    ORDER BY p.paid_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

/* تجميع حسب الطالب */
$payments_by_student = [];
foreach ($all_payments as $p) {
    $payments_by_student[$p['student_id']][] = $p;
}

/* ============================================================
   3) الأقسام للفلاتر
   ============================================================ */
$colleges = $conn->query("
    SELECT DISTINCT college_name FROM students ORDER BY college_name ASC
")->fetchAll(PDO::FETCH_COLUMN);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>سجل الدفعات - جامعة النبراس</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>

body{
    background: linear-gradient(135deg,#0e1528,#111b34);
    font-family:"Tajawal";
    color:white;
    padding-top:0;
}

/* NAVBAR */
.navbar-uni{
    backdrop-filter: blur(20px);
    background: rgba(255,255,255,0.06);
    border-bottom:1px solid rgba(255,255,255,0.12);
}
.navbar-brand{font-weight:bold;font-size:22px;}

/* BOX */
.glass-box{
    background: rgba(255,255,255,0.06);
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.12);
    padding:25px;
    margin-bottom:30px;
    backdrop-filter: blur(14px);
}

/* TABLE */
.table-box{border-radius:18px;overflow:hidden;border:1px solid rgba(255,255,255,0.12);}
.table thead{background:linear-gradient(45deg,#1f3c8d,#275adb);}
.table tbody tr{cursor:pointer;transition:.25s;}
.table tbody tr:hover{background:rgba(59,130,246,0.18);transform:scale(1.01);}

/* MODAL */
.modal-content{
    background: rgba(255,255,255,0.07);
    backdrop-filter: blur(18px);
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.15);
}
.payment-card{
    background: rgba(255,255,255,0.08);
    padding:14px;
    border-radius:12px;
    border:1px solid rgba(255,255,255,0.13);
    margin-bottom:14px;
}

.pay-img{
    width:200px;
    border-radius:12px;
    margin-top:10px;
    border:1px solid #ddd;
}

/* BADGES */
.badge-type{
    padding:5px 12px;
    border-radius:10px;
    font-weight:bold;
}
.cash{background:#4ade80;color:#064e2e;}
.elec{background:#60a5fa;color:#062b4f;}
.trans{background:#93c5fd;color:#1e3a8a;}
.free{background:#facc15;color:#4d3900;}

.btn-action{
    margin:3px;
    padding:6px 12px;
}

</style>

</head>
<body>

<!-- NAVBAR -->



<div class="container">

<h2 class="mb-4"><i class="bi bi-receipt"></i> سجل الدفعات</h2>

<!-- FILTERS -->
<div class="glass-box">
    <h5><i class="bi bi-filter"></i> الفلاتر</h5>
    <hr>

    <div class="row">

        <div class="col-md-3 mb-3">
            <label>بحث بالاسم</label>
            <input id="searchName" class="form-control" placeholder="مثال: أحمد علي">
        </div>

        <div class="col-md-3 mb-3">
            <label>القسم</label>
            <select id="filter_college" class="form-select">
                <option value="">الكل</option>
                <?php foreach($colleges as $c): ?>
                <option><?= $c ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-3 mb-3">
            <label>نوع الدراسة</label>
            <select id="filter_study" class="form-select">
                <option value="">الكل</option>
                <option>صباحي</option>
                <option>مسائي</option>
            </select>
        </div>

        <div class="col-md-3 mb-3">
            <label>تصدير</label><br>
            <a href="export_excel.php" class="btn btn-success w-100">
                <i class="bi bi-file-earmark-excel"></i> Excel
            </a>
        </div>

    </div>
</div>

<!-- TABLE -->
<div class="table-box">
<table class="table text-center" id="studentsTable">

<thead>
<tr>
   <th>#</th>
   <th>اسم الطالب</th>
   <th>القسم</th>
   <th>الدراسة</th>
   <th>الهاتف</th>
   <th>عدد الدفعات</th>
   <th>إجمالي المدفوع</th>
   <th>إجراءات</th>
</tr>
</thead>

<tbody>
<?php foreach($students as $i=>$st): 
    $sid = $st['id'];
    $pays = $payments_by_student[$sid] ?? [];
    $total_paid = array_sum(array_column($pays,'amount'));
?>
<tr onclick="openPaymentsModal(<?= $sid ?>)">
    <td><?= $i+1 ?></td>
    <td><?= $st['full_name'] ?></td>
    <td><?= $st['college_name'] ?></td>
    <td><?= $st['study_type'] ?></td>
    <td><?= $st['phone'] ?></td>
    <td><?= count($pays) ?></td>
    <td><?= number_format($total_paid) ?> د.ع</td>
    <td>
        <button class="btn btn-info btn-sm" onclick="event.stopPropagation(); openPaymentsModal(<?= $sid ?>)">
            عرض الدفعات
        </button>
    </td>
</tr>
<?php endforeach; ?>
</tbody>

</table>
</div>

</div>

<!-- ======================= MODAL ======================= -->
<div class="modal fade" id="paymentsModal" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">

      <div class="modal-header">
        <h4 class="modal-title"><i class="bi bi-cash-stack"></i> دفعات الطالب</h4>
        <button class="btn-close bg-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="modalBody"></div>

    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>

// كل الدفعات جاهزة من السيرفر
let paymentsData = <?= json_encode($payments_by_student) ?>;

/* ============================================================
   فتح مودال الدفعات
   ============================================================ */
function openPaymentsModal(student_id){

    let list = paymentsData[student_id] ?? [];
    let html = "";

    if(list.length === 0){
        html = `<p class="text-center text-white">لا توجد دفعات لهذا الطالب.</p>`;
    } else {

        let total = 0;
        list.forEach(p=> total += Number(p.amount));

        html += `
            <h5 class="mb-3">إجمالي المدفوع: <span class="text-success fw-bold">${total.toLocaleString()} د.ع</span></h5>
            <a href="add_payment.php?student_id=${student_id}" 
                class="btn btn-primary mb-3">
                <i class="bi bi-plus-lg"></i> إضافة دفعة جديدة
            </a>
        `;

        list.forEach(p=>{
            html += `
            <div class="payment-card">
                <div class="row">
                    <div class="col-md-8">

                        <b>المبلغ:</b> ${Number(p.amount).toLocaleString()} د.ع<br>
                        <b>رقم الوصل:</b> ${p.receipt_number ?? "—"}<br>
                        <b>نوع الدفع:</b> ${p.payment_type}<br>
                        <b>التاريخ:</b> ${p.paid_at}<br>
                        <b>الموظف:</b> ${p.staff_name ?? "—"}<br>
                        ${p.notes ? `<b>ملاحظة:</b> ${p.notes}<br>` : ""}
                    </div>

                    <div class="col-md-4 text-center">
                        ${p.receipt_image 
                            ? `<img src="../uploads/receipts/${p.receipt_image}" class="pay-img">`
                            : ""
                        }

                        <div class="mt-2">
                            <a href="edit_payment.php?id=${p.id}" 
                               class="btn btn-warning btn-sm btn-action">
                                <i class="bi bi-pencil"></i> تعديل
                            </a>

                            <button class="btn btn-danger btn-sm btn-action"
                                onclick="deletePayment(${p.id})">
                                <i class="bi bi-trash"></i> حذف
                            </button>

                            <a href="pdf_payment.php?id=${p.id}"
                               class="btn btn-secondary btn-sm btn-action">
                                <i class="bi bi-filetype-pdf"></i> PDF
                            </a>
                        </div>
                    </div>
                </div>
            </div>`;
        });
    }

    document.getElementById("modalBody").innerHTML = html;
    new bootstrap.Modal(document.getElementById("paymentsModal")).show();
}

/* ============================================================
   حذف دفعة
   ============================================================ */
function deletePayment(id){
    Swal.fire({
        title:"هل أنت متأكد؟",
        text:"سيتم حذف الدفعة نهائياً!",
        icon:"warning",
        showCancelButton:true,
        confirmButtonText:"نعم، احذف",
        cancelButtonText:"إلغاء",
        confirmButtonColor:"#e63946"
    }).then(res=>{
        if(res.isConfirmed){
            window.location = "delete_payment.php?id="+id;
        }
    });
}

/* ============================================================
   فلاتر البحث
   ============================================================ */
const rows = document.querySelectorAll("#studentsTable tbody tr");

document.getElementById("searchName").addEventListener("keyup", applyFilters);
document.getElementById("filter_college").addEventListener("change", applyFilters);
document.getElementById("filter_study").addEventListener("change", applyFilters);

function applyFilters(){
    let nameVal = document.getElementById("searchName").value.trim();
    let cVal = document.getElementById("filter_college").value.trim();
    let sVal = document.getElementById("filter_study").value.trim();

    rows.forEach(r=>{
        let name = r.children[1].innerText.trim();
        let col  = r.children[2].innerText.trim();
        let study= r.children[3].innerText.trim();

        let ok = true;

        if(nameVal && !name.includes(nameVal)) ok=false;
        if(cVal && col !== cVal) ok=false;
        if(sVal && study !== sVal) ok=false;

        r.style.display = ok ? "" : "none";
    });
}

</script>

</body>
</html>