<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "../config/app.php";
require_once "includes/header.php";
require_once "includes/navbar.php";

$student_id = intval($_GET['id'] ?? 0);
if ($student_id <= 0) {
    die("❌ Student ID missing");
}

/* ================================================================
   1) جلب بيانات الطالب + الحساب
================================================================ */
$q = $conn->prepare("
    SELECT 
        s.id,
        s.full_name,
        s.phone,
        s.college_name,
        s.study_type,
        s.admission_channel,
        s.college_fee,

        a.id AS account_id,
        a.total_fee,
        a.discount,
        a.paid,
        a.remaining,
        a.level,
        a.payment_plan,
        a.due_date,
        a.last_update,
        a.installment1,
        a.installment2,
        a.installment3,
        a.installment4,
        a.installment5,
        a.installment6

    FROM students s
    LEFT JOIN accounts a ON a.student_id = s.id
    WHERE s.id = ?
    LIMIT 1
");
$q->execute([$student_id]);
$data = $q->fetch(PDO::FETCH_ASSOC);

if (!$data) {
    die("❌ Student not found");
}

$account_id = $data["account_id"] ?? 0;

/* ================================================================
   2) حالة الحساب
================================================================ */
$is_full = ($account_id && $data['remaining'] <= 0);
$status_badge = $is_full ? "success" : "danger";
$status_text  = $is_full ? "مسدد بالكامل" : "غير مسدد";

/* ================================================================
   3) نسبة الخصم
================================================================ */
$discount_percent = 0;
if ($data['college_fee'] > 0 && $data['total_fee'] > 0) {
    $diff = $data['college_fee'] - $data['total_fee'];
    if ($diff > 0) {
        $discount_percent = floor(($diff / $data['college_fee']) * 100);
    }
}

/* ================================================================
   4) ترتيب المراحل
================================================================ */
$levels_order = [
    'المرحلة الأولى'  => 1,
    'المرحلة الثانية' => 2,
    'المرحلة الثالثة' => 3,
    'المرحلة الرابعة' => 4,
    'المرحلة الخامسة' => 5,
];
$current_level = $data['level'] ?? 'المرحلة الأولى';
$current_order = $levels_order[$current_level] ?? 1;

/* ================================================================
   5) جدول الأقساط الجديد installment_schedule
================================================================ */
$installments = [];
if ($account_id) {
    $s1 = $conn->prepare("
        SELECT *
        FROM installment_schedule
        WHERE account_id = ?
        ORDER BY installment_number ASC
    ");
    $s1->execute([$account_id]);
    $installments = $s1->fetchAll(PDO::FETCH_ASSOC);
}

/* ================================================================
   6) جدول الدفعات payments
================================================================ */
$p = $conn->prepare("
    SELECT *
    FROM payments
    WHERE student_id = ?
    ORDER BY paid_at DESC
");
$p->execute([$student_id]);
$payments = $p->fetchAll(PDO::FETCH_ASSOC);

?>

<div class="container mt-4">

    <!-- تنبيه بعد تغيير المرحلة -->
    <?php if (isset($_GET['level_updated'])): ?>
        <div class="alert alert-success text-center fw-bold">
            ✔ تم تحديث المرحلة وفتح حساب سنة جديدة
        </div>
    <?php endif; ?>

    <!-- العنوان -->
    <h2 class="mb-3">
        <i class="bi bi-person-vcard"></i> الملف المالي للطالب
    </h2>

    <div class="card p-4" style="background:#0f172a;border:1px solid #334155;color:white;">

        <!-- بيانات الطالب -->
        <div class="row">
            <div class="col-md-4 mb-3">
                <label class="text-info">اسم الطالب</label>
                <input class="form-control" value="<?= $data['full_name'] ?>" readonly>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-info">القسم</label>
                <input class="form-control" value="<?= $data['college_name'] ?>" readonly>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-info">القناة</label>
                <input class="form-control" value="<?= $data['admission_channel'] ?>" readonly>
            </div>
        </div>

        <!-- الحساب -->
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="text-info">المرحلة الحالية</label>
                <input class="form-control" value="<?= $current_level ?>" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-info">القسط الرسمي</label>
                <input class="form-control" value="<?= number_format($data['college_fee']) ?>" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-info">القسط بعد الخصم</label>
                <input class="form-control" value="<?= number_format($data['total_fee']) ?>" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-info">نسبة الخصم</label>
                <input class="form-control text-warning" value="<?= $discount_percent ?> %" readonly>
            </div>
        </div>

        <!-- المدفوع والمتبقي -->
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="text-info">المدفوع</label>
                <input class="form-control text-success" value="<?= number_format($data['paid']) ?>" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-info">المتبقي</label>
                <input class="form-control text-danger" value="<?= number_format($data['remaining']) ?>" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-info">خطة الدفع</label>
                <input class="form-control" value="<?= $data['payment_plan'] ?>" readonly>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-info">آخر تحديث</label>
                <input class="form-control" value="<?= $data['last_update'] ?>" readonly>
            </div>
        </div>

        <div class="text-center">
            <span class="badge bg-<?= $status_badge ?> fs-6 p-2"><?= $status_text ?></span>
        </div>

        <hr class="text-secondary">

        <!-- زر إضافة دفعة -->
        <div class="d-grid">
            <a href="add_payment.php?id=<?= $student_id ?>" class="btn btn-success btn-lg <?= $is_full?'disabled':'' ?>">
                <i class="bi bi-cash-stack"></i> إضافة دفعة جديدة
            </a>
        </div>

        <?php if ($is_full): ?>
            <small class="text-warning text-center d-block mt-1">الطالب مسدد بالكامل — لتفعيل الدفع يجب تغيير المرحلة</small>
        <?php endif; ?>

        <hr class="text-secondary">

        <!-- تغيير المرحلة -->
        <h4 class="text-info">تغيير المرحلة</h4>
        <form action="update_level.php" method="POST" class="row mt-2">
            <input type="hidden" name="student_id" value="<?= $student_id ?>">

            <div class="col-md-8 mb-2">
                <select name="new_level" class="form-select">
                    <option value="" disabled selected>اختر المرحلة الجديدة</option>
                    <?php foreach ($levels_order as $lvl => $ord):
                        $disabled = ($ord <= $current_order) ? "disabled" : "";
                    ?>
                        <option value="<?= $lvl ?>" <?= $disabled ?>><?= $lvl ?> <?= $disabled ? "(غير متاحة)" : "" ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4 mb-2">
                <button class="btn btn-primary w-100">تحديث المرحلة</button>
            </div>
        </form>

        <hr class="text-secondary">

        <!-- جدول الأقساط الجديد -->
        <h4 class="text-info">جدول الأقساط (الفعال)</h4>

        <?php if (!$installments): ?>
            <p class="text-warning">⚠ لا يوجد جدول أقساط. سيتم إنشاؤه عند أول دفعة.</p>
        <?php else: ?>

            <div class="table-responsive">
                <table class="table table-dark text-center">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>المبلغ</th>
                            <th>تاريخ الاستحقاق</th>
                            <th>المسدد</th>
                            <th>تاريخ الدفع</th>
                            <th>الحالة</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php foreach ($installments as $r): ?>
                            <tr>
                                <td><?= $r['installment_number'] ?></td>
                                <td><?= number_format($r['amount']) ?> د.ع</td>
                                <td><?= $r['due_date'] ?></td>
                                <td><?= number_format($r['paid_amount']) ?> د.ع</td>
                                <td><?= $r['paid_date'] ?: '-' ?></td>
                                <td><?= $r['status'] ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

        <?php endif; ?>

    </div>

    <!-- جدول الدفعات -->
    <h3 class="mt-5 mb-3">💵 دفعات الطالب</h3>

    <div class="row">
        <?php foreach ($payments as $pay): ?>
            <div class="col-md-4">
                <div class="card mb-4" style="background:#1e293b;border:1px solid #334155">

                    <?php if ($pay['receipt_image']): ?>
                        <img src="../uploads/receipts/<?= $pay['receipt_image'] ?>"
                             style="width:100%;height:200px;object-fit:cover;">
                    <?php else: ?>
                        <div style="height:200px;background:#0f172a;display:flex;align-items:center;justify-content:center;">
                            <i class="bi bi-image text-secondary" style="font-size:48px;"></i>
                        </div>
                    <?php endif; ?>

                    <div class="card-body text-white">
                        <h5>💰 <?= number_format($pay['amount']) ?> د.ع</h5>
                        <p class="mb-2">
                            <b>الوصل:</b> <?= $pay['receipt_number'] ?><br>
                            <b>النوع:</b> <?= $pay['payment_type'] ?><br>
                            <b>التاريخ:</b> <?= $pay['paid_at'] ?>
                        </p>

                        <a href="view_payment.php?id=<?= $pay['id'] ?>" class="btn btn-outline-info w-100">
                            عرض التفاصيل
                        </a>
                    </div>

                </div>
            </div>
        <?php endforeach; ?>
    </div>

</div>

<?php require_once "includes/footer.php"; ?>