<?php
session_start();
if (!isset($_SESSION['finance_user'])) {
    die("❌ Unauthorized");
}

require_once "../config/db.php";
require_once "../config/app.php";
require_once "../config/whatsapp.php";

$finance_user_id = $_SESSION['finance_user']['id'] ?? 0;

// التحقق من البيانات المرسلة
if (
    !isset($_POST['schedule_id']) ||
    !isset($_POST['new_due_date']) ||
    !isset($_POST['reason']) ||
    !isset($_POST['student_id']) ||
    !isset($_POST['account_id'])
) {
    die("❌ Missing data");
}

$schedule_id  = intval($_POST['schedule_id']);
$new_due_date = $_POST['new_due_date'];
$reason       = trim($_POST['reason']);
$student_id   = intval($_POST['student_id']);
$account_id   = intval($_POST['account_id']);

/* ============================================================
   1) جلب بيانات القسط
============================================================ */
$q = $conn->prepare("
    SELECT 
        s.full_name, 
        s.phone, 
        sch.due_date
    FROM installment_schedule sch
    JOIN accounts a ON a.id = sch.account_id
    JOIN students s ON s.id = a.student_id
    WHERE sch.id = ?
    LIMIT 1
");
$q->execute([$schedule_id]);
$row = $q->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    die("❌ Schedule not found");
}

$old_date = $row['due_date'];

/* ============================================================
   2) تحديث تاريخ الاستحقاق
============================================================ */
$u = $conn->prepare("
    UPDATE installment_schedule
    SET due_date = ?, status = 'pending'
    WHERE id = ?
");
$u->execute([$new_due_date, $schedule_id]);

/* ============================================================
   3) تسجيل سجل التعديل  (متوافق مع جدول due_date_logs الحقيقي)
============================================================ */

$log = $conn->prepare("
    INSERT INTO due_date_logs(schedule_id, old_due_date, new_due_date, reason, changed_by, changed_at)
    VALUES (?, ?, ?, ?, ?, NOW())
");

$log->execute([
    $schedule_id,
    $old_date,
    $new_due_date,
    $reason,
    $finance_user_id
]);

/* ============================================================
   4) إشعار واتساب إن رغبت
============================================================ */

// $message = "📢 *تعديل تاريخ استحقاق القسط*
// الطالب: {$row['full_name']}
// من: $old_date
// إلى: $new_due_date
// السبب: $reason";
// sendWhatsAppMessage($row['phone'], $message);

/* ============================================================
   5) العودة للصفحة
============================================================ */

header("Location: add_payment.php?id=$student_id&due_updated=1");
exit;
?>