<?php
session_start();
if(!isset($_SESSION['finance_user'])){ header("Location: login.php"); exit; }

require_once "../config/db.php";
require_once "includes/header.php";
require_once "includes/navbar.php";
require_once "../config/app.php";

/* ============================================================
   1) ملخص المحاسبين
============================================================ */
$userStats = $conn->query("
    SELECT 
        u.id,
        u.username,
        u.name AS full_name,
        COUNT(p.id) AS payments_count,
        COALESCE(SUM(p.amount),0) AS total_amount,
        MAX(p.paid_at) AS last_payment_at
    FROM finance_users u
    LEFT JOIN payments p ON p.finance_user_id = u.id
    GROUP BY u.id, u.username, u.name
    ORDER BY total_amount DESC
")->fetchAll(PDO::FETCH_ASSOC);

/* ============================================================
   2) تفاصيل مستخدم معين
============================================================ */
$selected_user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$userPayments = [];
$userInfo = null;

if($selected_user_id){

    $userInfo = $conn->prepare("SELECT * FROM finance_users WHERE id = ?");
    $userInfo->execute([$selected_user_id]);
    $userInfo = $userInfo->fetch(PDO::FETCH_ASSOC);

    $stmt = $conn->prepare("
        SELECT 
            p.*, 
            s.full_name AS student_name
        FROM payments p
        JOIN students s ON s.id = p.student_id
        WHERE p.finance_user_id = ?
        ORDER BY p.paid_at DESC
        LIMIT 500
    ");
    $stmt->execute([$selected_user_id]);
    $userPayments = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

?>

<style>

/* خلفية */
body{
    background: linear-gradient(135deg,#0f172a,#1e293b,#0f172a);
    font-family: 'Tajawal', sans-serif;
    color:white;
}

/* Apple Glass Card */
.glass-card{
    background: rgba(255,255,255,0.08);
    border-radius:28px;
    backdrop-filter: blur(18px);
    -webkit-backdrop-filter: blur(18px);
    padding:25px;
    margin-bottom:25px;
    border:1px solid rgba(255,255,255,0.2);
    box-shadow:0 25px 60px rgba(0,0,0,0.5);
    transition:.3s;
}
.glass-card:hover{
    transform: translateY(-6px);
    box-shadow:0 30px 80px rgba(0,0,0,0.7);
}

/* صندوق المستخدم */
.user-box{
    background: rgba(255,255,255,0.15);
    padding:20px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.25);
    transition:.3s;
}
.user-box:hover{
    background: rgba(255,255,255,0.22);
    transform:scale(1.02);
}

/* جدول */
.table-dark-sm td,
.table-dark-sm th{
    padding:10px 14px;
    font-size:15px;
}

/* صورة الوصل */
.receipt-img{
    width:70px;
    height:70px;
    border-radius:12px;
    object-fit:cover;
    border:2px solid rgba(255,255,255,0.25);
}

/* قسم بروفايل المستخدم */
.profile-box{
    background: rgba(255,255,255,0.18);
    padding:25px;
    border-radius:26px;
    display:flex;
    align-items:center;
    gap:20px;
    border:1px solid rgba(255,255,255,0.28);
}
.profile-img{
    width:90px;
    height:90px;
    border-radius:50%;
    background:#334155;
    display:flex;
    align-items:center;
    justify-content:center;
    font-size:38px;
}
.profile-details h3{
    margin:0;
    font-weight:900;
}
.profile-details p{
    margin:0;
    font-size:15px;
    opacity:.8;
}

/* رسائل العمليات – Apple Timeline */
.timeline-box{
    padding:15px;
    border-radius:20px;
    background:rgba(30,41,59,0.7);
    border:1px solid rgba(255,255,255,0.2);
    margin-bottom:18px;
}
.timeline-header{
    display:flex;
    justify-content:space-between;
    font-size:14px;
    opacity:.8;
}
.timeline-body{
    margin-top:10px;
}
.timeline-label{
    font-size:20px;
    font-weight:800;
    color:#38bdf8;
}
</style>

<div class="container my-4">

    <h2 class="mb-3">
        <i class="bi bi-magic"></i> واجهة نشاط المحاسبين 
    </h2>

    <!-- قائمة المستخدمين -->
    <div class="glass-card">
        <h4 class="mb-3">🧑‍💼 جميع المستخدمين</h4>

        <div class="row">
            <?php foreach($userStats as $u): ?>
            <div class="col-md-4">
                <a href="users_activity.php?user_id=<?= $u['id'] ?>" style="text-decoration:none;color:white;">
                    <div class="user-box mb-3">
                        <h3><?= $u['full_name'] ?></h3>
                        <p>👤 المستخدم: <?= $u['username'] ?></p>
                        <p>💵 الدفعات: <?= number_format($u['payments_count']) ?></p>
                        <p>💰 مجموع الأموال: <?= number_format($u['total_amount']) ?> د.ع</p>
                    </div>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- تفاصيل مستخدم -->
    <?php if($selected_user_id && $userInfo): ?>

    <div class="glass-card">

        <!-- بروفايل المستخدم -->
        <div class="profile-box mb-4">
            <div class="profile-img">
                <i class="bi bi-person-fill"></i>
            </div>
            <div class="profile-details">
                <h3><?= $userInfo["name"] ?></h3>
                <p>اسم المستخدم: <?= $userInfo["username"] ?></p>
                <p>رقم المستخدم: #<?= $userInfo["id"] ?></p>
            </div>
        </div>

        <h4 class="mb-3">📜 السجل الكامل للعمليات</h4>

        <?php foreach($userPayments as $p): ?>
        <div class="timeline-box">

            <div class="timeline-header">
                <span>📅 <?= $p["paid_at"] ?></span>
                <span>🧾 وصل رقم <?= $p["receipt_number"] ?></span>
            </div>

            <div class="timeline-body">

                <div class="timeline-label">
                    + <?= number_format($p["amount"]) ?> د.ع
                </div>

                <p>👤 الطالب: <?= $p["student_name"] ?></p>
                <p>💳 طريقة الدفع: <?= $p["payment_type"] ?></p>

                <?php if($p["notes"]): ?>
                <p>📝 ملاحظات: <?= $p["notes"] ?></p>
                <?php endif; ?>

                <?php if($p["receipt_image"]): ?>
                <p>📷 صورة الوصل:</p>
                <img src="../uploads/receipts/<?= $p['receipt_image'] ?>" class="receipt-img">
                <?php endif; ?>

            </div>

        </div>
        <?php endforeach; ?>

        <?php if(!$userPayments): ?>
        <p class="text-center mt-4">لا توجد عمليات لهذا المستخدم.</p>
        <?php endif; ?>

    </div>

    <?php endif; ?>

</div>

<?php require_once "includes/footer.php"; ?>