<?php
session_start();
if(!isset($_SESSION['finance_user'])){ header("Location: login.php"); exit; }

require_once "../config/db.php";
require_once "includes/header.php";
require_once "includes/navbar.php";

// ==========================
//      تحديد طريقة العرض
// ==========================

// إذا كان الرابط يحتوي student_id → عرض جميع الدفعات لطالب
$student_id = isset($_GET["student_id"]) ? intval($_GET["student_id"]) : null;

// إذا كان الرابط يحتوي id → عرض دفعة واحدة فقط
$payment_id = isset($_GET["id"]) ? intval($_GET["id"]) : null;


// ==========================
//     عرض دفعة واحدة
// ==========================
if ($payment_id && !$student_id) {

    $q = $conn->prepare("
        SELECT p.*, s.full_name
        FROM payments p
        JOIN students s ON s.id = p.student_id
        WHERE p.id = ?
    ");
    $q->execute([$payment_id]);
    $p = $q->fetch(PDO::FETCH_ASSOC);

    if (!$p) die("❌ لم يتم العثور على الدفعة");

?>
<body style="background:#0f172a;color:white;font-family:Tajawal;">

<div class="container mt-4">

<h2 class="mb-4"><i class="bi bi-receipt"></i> تفاصيل الدفعة</h2>

<div class="p-4" style="
    background:rgba(255,255,255,0.06);
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.12);
    backdrop-filter:blur(12px);
    box-shadow:0 10px 25px rgba(0,0,0,0.4);
">

    <div class="row">

        <!-- الصورة -->
        <div class="col-md-4 text-center">
            <?php if(!empty($p["receipt_image"])): ?>
                <div style="
                    width:220px;
                    height:220px;
                    border-radius:14px;
                    overflow:hidden;
                    border:2px solid #3b82f6;
                    margin:auto;
                ">
                    <img src="../uploads/receipts/<?= $p['receipt_image'] ?>" 
                         style="width:100%;height:100%;object-fit:cover;">
                </div>

                <a href="../uploads/receipts/<?= $p['receipt_image'] ?>" 
                   target="_blank" class="btn btn-primary mt-3">
                   <i class="bi bi-eye"></i> عرض الصورة
                </a>

            <?php else: ?>
                <p class="text-warning mt-4">— لا توجد صورة مرفوعة —</p>
            <?php endif; ?>
        </div>

        <!-- التفاصيل -->
        <div class="col-md-8">

            <p><b>الطالب:</b> <?= $p["full_name"] ?></p>
            <p><b>المبلغ:</b> <?= number_format($p["amount"]) ?> د.ع</p>
            <p><b>نوع الدفع:</b> <?= $p["payment_type"] ?></p>
            <p><b>رقم الوصل:</b> <?= $p["receipt_number"] ?></p>
            <p><b>التاريخ:</b> <?= $p["paid_at"] ?></p>

            <?php if (!empty($p["notes"])): ?>
                <p><b>ملاحظات:</b> <?= $p["notes"] ?></p>
            <?php endif; ?>

        </div>

    </div>
</div>

</div>

</body>
</html>

<?php
exit;
} // END single payment



// ==========================
//     عرض جميع دفعات طالب
// ==========================
if (!$student_id) 
    die("❌ لا يوجد معرف طالب student_id");

$q = $conn->prepare("
    SELECT p.*, s.full_name 
    FROM payments p
    JOIN students s ON s.id = p.student_id
    WHERE p.student_id = ?
    ORDER BY p.id DESC
");
$q->execute([$student_id]);
$payments = $q->fetchAll(PDO::FETCH_ASSOC);

?>
<body style="background:#0f172a;color:white;font-family:Tajawal;">

<div class="container mt-4">

<h2 class="mb-4">
    <i class="bi bi-cash-stack"></i>
    جميع دفعات الطالب
</h2>

<?php if (count($payments) == 0): ?>
    <p class="text-warning text-center">لا توجد دفعات مسجلة بعد.</p>
<?php endif; ?>


<?php foreach($payments as $p): ?>
<div style="
    background:rgba(255,255,255,0.06);
    border-radius:18px;
    padding:20px;
    margin-bottom:25px;
    border:1px solid rgba(255,255,255,0.12);
    box-shadow:0 10px 25px rgba(0,0,0,0.5);
    backdrop-filter:blur(12px);
">

    <h4 class="mb-3">
        <i class="bi bi-receipt"></i> دفعة رقم: <?= $p["id"] ?>
    </h4>

    <div class="row">

        <div class="col-md-4 text-center">

            <?php if(!empty($p["receipt_image"])): ?>

                <div style="
                    width:220px;
                    height:220px;
                    border-radius:14px;
                    overflow:hidden;
                    border:2px solid #3b82f6;
                    margin:auto;
                ">
                    <img src="../uploads/receipts/<?= $p['receipt_image'] ?>" 
                         style="width:100%;height:100%;object-fit:cover;">
                </div>

                <a href="../uploads/receipts/<?= $p['receipt_image'] ?>" 
                   target="_blank" class="btn btn-primary mt-3">
                   <i class="bi bi-eye"></i> فتح الوصل
                </a>

            <?php else: ?>
                <p class="text-warning mt-3">— لا توجد صورة —</p>
            <?php endif; ?>

        </div>

        <div class="col-md-8">

            <div class="info-box mb-2"><b>الطالب:</b> <?= $p["full_name"] ?></div>
            <div class="info-box mb-2"><b>المبلغ:</b> <?= number_format($p["amount"]) ?> د.ع</div>
            <div class="info-box mb-2"><b>نوع الدفع:</b> <?= $p["payment_type"] ?></div>
            <div class="info-box mb-2"><b>رقم الوصل:</b> <?= $p["receipt_number"] ?></div>
            <div class="info-box mb-2"><b>التاريخ:</b> <?= $p["paid_at"] ?></div>

            <?php if (!empty($p["notes"])): ?>
                <div class="info-box mb-2"><b>ملاحظات:</b> <?= $p["notes"] ?></div>
            <?php endif; ?>

        </div>

    </div>

</div>
<?php endforeach; ?>

</div>

</body>
</html>