<?php
session_start();
require_once "../config/db.php";
require_once "../config/app.php";
require_once "../vendor/autoload.php";

// -------------------------------------
// 1) جلب ID الطالب عبر GET
// -------------------------------------
$student_id = intval($_GET["id"] ?? 0);
if ($student_id <= 0) {
    // عرض خطأ فقط بدون توقف السيرفر
    echo "<h2 style='color:red;text-align:center;margin-top:50px;'>❌ Student ID missing</h2>";
    exit;
}

// -------------------------------------
// 2) جلب بيانات الطالب
// -------------------------------------
$st = $conn->prepare("
    SELECT s.*, a.total_fee, a.paid, a.remaining, a.level
    FROM students s
    LEFT JOIN accounts a ON a.student_id = s.id
    WHERE s.id = ?
");
$st->execute([$student_id]);
$student = $st->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    echo "<h2 style='color:red;text-align:center;margin-top:50px;'>❌ Student Not found</h2>";
    exit;
}

// -------------------------------------
// 3) جلب سجل الدفعات
// -------------------------------------
$payment_stmt = $conn->prepare("
    SELECT *
    FROM payments
    WHERE student_id=?
    ORDER BY paid_at DESC
");
$payment_stmt->execute([$student_id]);
$payments = $payment_stmt->fetchAll(PDO::FETCH_ASSOC);

// -------------------------------------
// 4) إعداد MPDF
// -------------------------------------
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'orientation' => 'P',
    'default_font' => 'dejavusans',
    'margin_top' => 10,
    'margin_bottom' => 10,
    'margin_left' => 10,
    'margin_right' => 10,
    'autoPageBreak' => true,
    'autoLangToFont' => true,
    'autoScriptToLang' => true
]);

$logo = "../assets/images/logo.png";
$student_name = $student["full_name"];

$mpdf->SetTitle("كشف حساب - $student_name");

// -------------------------------------
// 5) HTML التقرير
// -------------------------------------
$html = '
<style>
body {
    font-family: "dejavusans";
    direction: rtl;
    text-align: right;
    font-size: 14px;
}
.header { text-align:center; margin-bottom: 15px; }
.logo { width:120px; }
.section-title { font-size:18px; font-weight:700; color:#2563eb; margin-top:20px; }
.box { background:#f1f5f9; padding:10px; border-radius:10px; }
.payment-card { border:1px solid #ccc; padding:10px; border-radius:10px; margin-top:10px; }
.payment-img { width:260px; border-radius:10px; margin-top:10px; }
.footer { margin-top:20px; font-size:12px; direction:ltr; color:#444; }
</style>

<div class="header">
    <img src="'.$logo.'" class="logo">
    <h2>كشف الحساب المالي للطالب</h2>
    <h3>'.$student_name.'</h3>
</div>

<div class="section-title">البيانات الأساسية</div>
<div class="box">
<b>اسم الطالب:</b> '.$student["full_name"].'<br>
<b>القسم:</b> '.$student["college_name"].'<br>
<b>نوع الدراسة:</b> '.$student["study_type"].'<br>
<b>المرحلة:</b> '.$student["level"].'<br>
<b>الهاتف:</b> '.$student["phone"].'<br>
</div>

<div class="section-title">الوضع المالي</div>
<div class="box">
<b>إجمالي القسط:</b> '.number_format($student["total_fee"]).' د.ع<br>
<b>المدفوع:</b> '.number_format($student["paid"]).' د.ع<br>
<b>المتبقي:</b> '.number_format($student["remaining"]).' د.ع<br>
</div>

<div class="section-title">سجل الدفعات</div>
';

foreach ($payments as $p) {

    // صورة الوصل
    $img = "";
    if ($p["receipt_image"]) {
        $path = "../uploads/receipts/".$p["receipt_image"];
        if (file_exists($path)) {
            $img = '<img src="'.$path.'" class="payment-img">';
        }
    }

    $html .= '
    <div class="payment-card">
        <b>المبلغ:</b> '.number_format($p["amount"]).' د.ع<br>
        <b>رقم الوصل:</b> '.($p["receipt_number"] ?: "—").'<br>
        <b>نوع الدفع:</b> '.$p["payment_type"].'<br>
        <b>التاريخ:</b> '.$p["paid_at"].'<br>
        '.(!empty($p["notes"]) ? "<b>ملاحظة:</b> ".htmlspecialchars($p["notes"])."<br>" : "").'
        '.$img.'
    </div>';
}

$html .= '
<div class="footer">
Generated on: '.date("Y-m-d H:i:s").'
</div>
';

$mpdf->WriteHTML($html);

// -------------------------------------
// 6) عرض PDF فقط بدون حفظ أبداً
// -------------------------------------
$pdf_name = "كشف الحساب المالي - ".$student_name.".pdf";
$mpdf->Output($pdf_name, "I");  // فتح مباشر بدون حفظ

exit;
?>