<?php
// ============================
//  PDF Test File
//  test_pdf.php
// ============================

session_start();

require_once __DIR__ . "/config/db.php";
require_once __DIR__ . "/config/pdf.php";  // يحتوي generatePDF()

echo "<h2>🔍 PDF TEST START</h2>";

// 1) جلب أي طالب (أول طالب في قاعدة البيانات)
$student = $conn->query("SELECT * FROM students ORDER BY id ASC LIMIT 1")->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("❌ لا يوجد طلاب في قاعدة البيانات لاختبار PDF");
}

// 2) محتوى PDF تجريبي
$html = "
<html dir='rtl' lang='ar'>
<head>
<meta charset='UTF-8'>
<style>
    body { font-family: dejavusans; }
    h1 { text-align:center; font-size:22px; }
    .box {
        margin-top:25px;
        padding:15px;
        border:1px solid #000;
        font-size:16px;
    }
</style>
</head>

<body>

<h1>✔ PDF Test – نجاح إنشاء PDF</h1>

<div class='box'>
    <b>اسم الطالب:</b> {$student['full_name']}<br>
    <b>الرقم الامتحاني:</b> {$student['exam_number']}<br>
    <b>الكلية:</b> {$student['college_name']}<br>
    <b>التاريخ:</b> " . date("Y-m-d H:i") . "
</div>

</body>
</html>
";

// 3) مسار الملف
$pdf_folder = __DIR__ . "/uploads/pdfs/";
if (!is_dir($pdf_folder)) mkdir($pdf_folder, 0777, true);

$output_path = $pdf_folder . "test.pdf";

// 4) توليد PDF
try {
    generatePDF($html, $output_path);
    echo "<p style='color:green;font-size:18px;'>✔ تم توليد PDF بنجاح</p>";
    echo "<a href='uploads/pdfs/test.pdf' target='_blank'>📄 اضغط لفتح الملف</a>";
} 
catch (Exception $e) {
    echo "<p style='color:red;font-size:18px;'>❌ فشل توليد PDF</p>";
    echo "رسالة الخطأ: " . $e->getMessage();
}

?>
